package gov.va.genisis2.bo;

import gov.va.genisis2.common.enums.WorkflowStatusEnum;
import gov.va.genisis2.util.HelperUtils;
import gov.va.genisis2.util.rest.helper.ResponseWrapper;
import gov.va.genisis2.vo.CopyTableSource;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

import javax.annotation.Resource;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * The Class BusinessHelper.
 */
@Component
public class BusinessHelper {

	private static final Logger LOGGER = LoggerFactory.getLogger(BusinessHelper.class);

	private static final String EMAILID_DELIMETER = ",";

	@Resource(name="workflowDeadendsList")
	private List<String> workflowDeadendsList;
	
	@Resource(name="allowedOperations")
	private List<String> allowedOperations;

	@Resource(name="notificationAllowedStutuses")
	private List<String> notificationAllowedStutuses;
	
	@Resource(name="returnToDdmAllowedStutuses")
	private List<String> returnToDdmAllowedStutuses;

	
	public ResponseWrapper validateCopyTableSource(CopyTableSource copyTableSource, CopyTableSource jsonRequest, ResponseWrapper wrapper) {

		// Get required properties
		String tcSourceDataBaseServerName = copyTableSource.getTcSourceDataBaseServerName();
		String tcSourceDataBaseName = copyTableSource.getTcSourceDataBaseName();
		String sourceSchemaName = jsonRequest.getSourceSchemaName();
		String tcDestinationDataBaseServerName = copyTableSource.getTcDestinationDataBaseServerName();
		String tcDestinationDataBaseUserName = copyTableSource.getTcDestinationDataBaseUserName();
		String tcDestinationDataBaseUserPassvalue = copyTableSource.gettcDestinationDataBaseUserPassvalue();
		String tcDestinationServerDataBaseName = copyTableSource.getTcDestinationServerDataBaseName();
		String destinationSchemaName = jsonRequest.getDestinationSchemaName();
		String tcManagementDataBaseServerName = copyTableSource.getTcManagementDataBaseServerName();
		String tcManagementDataBaseUserName = copyTableSource.getTcManagementDataBaseUserName();
		String tcManagementDataBaseUserPassvalue = copyTableSource.gettcManagementDataBaseUserPassvalue();
		String tcManagementDataBaseSchema = copyTableSource.getTcManagementDataBaseSchema();
		String copyTable = jsonRequest.getTableName();
		String copyTableScript = copyTableSource.getCmdFilePath();
		String tcManagementDataBaseName = copyTableSource.getTcManagementDataBaseName();
		String tcTemporaryDataBaseName = copyTableSource.getTcTemporaryDataBaseName();

		boolean sourceDBFlag = StringUtils.isBlank(tcSourceDataBaseServerName) || StringUtils.isBlank(tcSourceDataBaseName);
		boolean schemaFlag = StringUtils.isBlank(sourceSchemaName);
		boolean destDBFlag = StringUtils.isBlank(tcDestinationDataBaseServerName) || StringUtils.isBlank(tcDestinationDataBaseUserName) || StringUtils.isBlank(tcDestinationDataBaseUserPassvalue);
		boolean sourceSchemaDestFlag = sourceDBFlag || schemaFlag || destDBFlag;

		boolean destServFlag = sourceSchemaDestFlag || StringUtils.isBlank(tcDestinationServerDataBaseName) || StringUtils.isBlank(destinationSchemaName);

		boolean mgmtDBFlag = StringUtils.isBlank(tcManagementDataBaseServerName) || StringUtils.isBlank(tcManagementDataBaseSchema) || StringUtils.isBlank(tcManagementDataBaseName);
		boolean mgmtDBUserFlag = StringUtils.isBlank(tcManagementDataBaseUserName) || StringUtils.isBlank(tcManagementDataBaseUserPassvalue);
		boolean destMgmtflag = destServFlag || mgmtDBFlag || mgmtDBUserFlag;

		boolean copyTableFlag = StringUtils.isBlank(tcTemporaryDataBaseName) || StringUtils.isBlank(copyTable) || StringUtils.isBlank(copyTableScript);

		// Check for all properties are present
		if (sourceSchemaDestFlag || destMgmtflag || copyTableFlag) {
			LOGGER.error("One or more properties in genisis2.properties file seems blank");
			wrapper.setResponse(jsonRequest);
			wrapper.setMessage("One or more properties in genisis2.properties file seems blank");
			wrapper.setSuccess(false);
			return wrapper;
		}
		copyTableScript=FilenameUtils.normalize(copyTableScript);
		copyTableScript=copyTableScript.replace("\\", "\\/");
		File file = new File(copyTableScript);
		// Check shell script available on Linux server
	/*	if (!file.isFile()) {
			LOGGER.error("The file {} does not exist", copyTableScript);
			wrapper.setResponse(jsonRequest);
			wrapper.setMessage("Copy table failed. " + copyTableScript + " does not exist");
			wrapper.setSuccess(false);
			return wrapper;
		}*/
			
	   List<String> commands = new ArrayList<String>();
	   commands.add(copyTableScript);
	   commands.add(tcSourceDataBaseServerName);
	   commands.add(tcSourceDataBaseName);
	   commands.add(sourceSchemaName);
	   commands.add(tcDestinationDataBaseServerName);
	   commands.add(tcDestinationDataBaseUserName);
	   commands.add(tcDestinationDataBaseUserPassvalue);
	   commands.add(tcDestinationServerDataBaseName);
	   commands.add(destinationSchemaName);
	   commands.add(tcManagementDataBaseServerName);
	   commands.add(tcManagementDataBaseUserName);
	   commands.add(tcManagementDataBaseUserPassvalue);
	   commands.add(tcManagementDataBaseName);
	   commands.add(tcTemporaryDataBaseName);
	   commands.add(tcManagementDataBaseSchema);
	   commands.add(copyTable);
	   wrapper.setResponse(commands);
	   wrapper.setSuccess(true);

		return wrapper;
	}

	public boolean getWorkflowDeadEnds(String status) {
		boolean workflowDeadEnds = false;
		StringJoiner terminatedStates = new StringJoiner(EMAILID_DELIMETER);
		for (Object obj : workflowDeadendsList) {
			if (obj != null) {
				terminatedStates.add(obj.toString());
			}
		}
		if (StringUtils.isBlank(terminatedStates.toString())) {
			LOGGER.error("No workflow deadends found!");
			workflowDeadEnds = true;
		}
		if (StringUtils.countMatches(terminatedStates.toString(), status) > 0) {
			workflowDeadEnds = true;
		}
		return workflowDeadEnds;
	}
	
	public boolean isCancelAllowed(String status) {
		boolean flag;
		flag = StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.SUBMITTED.getDesc()) ? true : false;
		flag = flag || (StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.RETURNED.getDesc())) ? true : false;
		flag = flag || (StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.SENT.getDesc())) ? true : false;
		flag = flag || (StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.REQUESTACCEPTED.getDesc())) ? true : false;
		flag = flag || (StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.RESULTSDELIVERED.getDesc())) ? true : false;
		return flag;
	}

	public boolean isOperationAllowed(String operation) {
		return allowedOperations.stream().filter(s -> s.equalsIgnoreCase(operation)).findFirst().isPresent();
	}
	
	public boolean isNotificationAllowed(String status) {
		return notificationAllowedStutuses.stream().filter(s -> s.equalsIgnoreCase(status)).findFirst().isPresent();
	}
	
	public boolean isReturnToDDMAllowed(String status) {
		return returnToDdmAllowedStutuses.stream().filter(s -> s.equalsIgnoreCase(status)).findFirst().isPresent();
	}
	
	/**
	 * @param allowedOperations the allowedOperations to set
	 */
	public void setAllowedOperations(List<String> allowedOperations) {
		this.allowedOperations = allowedOperations;
	}

	/**
	 * @param notificationAllowedStutuses the notificationAllowedStutuses to set
	 */
	public void setNotificationAllowedStutuses(List<String> notificationAllowedStutuses) {
		this.notificationAllowedStutuses = notificationAllowedStutuses;
	}

	/**
	 * @param returnToDdmAllowedStutuses the returnToDdmAllowedStutuses to set
	 */
	public void setReturnToDdmAllowedStutuses(List<String> returnToDdmAllowedStutuses) {
		this.returnToDdmAllowedStutuses = returnToDdmAllowedStutuses;
	}
	
	
	private static char cleanChar(char aChar) {
		// 0 - 9
		for (int i = 48; i < 58; ++i) {
			if (aChar == i)
				return (char) i;
		}
		// 'A' - 'Z'
		for (int i = 65; i < 91; ++i) {
			if (aChar == i)
				return (char) i;
		}
		// 'a' - 'z'
		for (int i = 97; i < 123; ++i) {
			if (aChar == i)
				return (char) i;
		}
		// other valid characters
		switch (aChar) {
		case '/':
			return '/';
		case '.':
			return '.';
		case '-':
			return '-';
		case '_':
			return '_';
		case ' ':
			return ' ';
		}
		return '%';
	}
	
	}

